﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApplication1
{
    class Program
    {
        static void Main(string[] args)
        {
            Dokument d = new Dokument();
            Paragraf paragraf = new Paragraf("Molimo pametne i postene da cuvaju zdravlje i ne gube nadu. Za svaki slucaj. Ako nam niko drugi ne pomogne.");
            d.AddElement(paragraf);
            Recenica recenica1 = new Recenica("Deco, mozete misliti kakav je zivot kada je od kolevke pa do groba najlepse djacko doba");
            d.AddElement(recenica1);
            Recenica recenica2 = new Recenica("Vise je znanja i vestine (inteligencije, duha, maste i ukusa) ulozila Koka-kola za propagandu svoje obojene i zasecerene vode, nego skola za slavu i velicanje citanja i pisanja");
            d.AddElement(recenica2);
            Pravougaonik pravougaonik = new Pravougaonik(1, 1, 2, 2, "crvena");
            d.AddElement(pravougaonik);
            Console.WriteLine("String reprezentacije svih elemenata u dokumentu:");
            Console.WriteLine(d.ToString());
            Console.WriteLine("Sav tekst koji se javlja u dokumentu:");
            d.PrintText();
            int a = 0;
            foreach (var x in d.GetTextElements())
            {
                string s = x.GetText();
                for (int i = 0; i < s.Length; ++i)
                {
                    if (s[i] == 'a')
                    {
                        a++;
                    }
                }
            }
            Console.WriteLine("\nU svim tekstualnim elementima u dokumentu ukupno ima " + a + " slova a.");
            Console.ReadKey();
        }
    }
   
    class ElementUDokumentu
    {
        public string vrsta
        {
            set;
            get;
        }

        public ElementUDokumentu(string x)
        {
            vrsta = x;
        }

        public override string ToString()
        {
            return vrsta;
        }
    }

    abstract class TekstualniElement : ElementUDokumentu
    {
        public abstract string GetText();

        public TekstualniElement(string x) : base(x)
        {
            vrsta = x;
        }
    }

    class Recenica : TekstualniElement
    {
        public string recenica
        {
            set;
            get;
        }

        public Recenica(string x) : base("recenica")
        {
            recenica = x;
        }

        public override string GetText()
        {
            return recenica + ".";
        }

        public override string ToString()
        {
            return vrsta + ": " + GetText(); 
        }
    }

    class Paragraf : TekstualniElement
    {
        public StringBuilder tekst
        {
            set;
            get;
        }

        public Paragraf(string x) : base("paragraf")
        {
            if (x.IndexOf("\n") != -1)
            {
                tekst = new StringBuilder(x.Substring(0, x.IndexOf("\n")));
            }
            else
            {
                tekst = new StringBuilder(x);
            }
        }

        public Paragraf(Recenica x) : base("paragraf")
        {
            tekst = new StringBuilder(x.GetText());
        }

        public void DodajTekst(string x)
        {
            tekst = new StringBuilder(tekst.ToString() + x);
        }

        public void DodajTekst(Recenica x)
        {
            tekst = new StringBuilder(tekst.ToString() + " " + x.GetText());
        }

        public override string GetText()
        {
            return tekst.ToString() + "\n";
        }

        public override string ToString()
        {
            return vrsta + ": " + tekst.ToString();
        }
    }

    class GrafickiElement : ElementUDokumentu
    {
        public string boja
        {
            set;
            get;
        }

        public GrafickiElement(string x, string y) : base(y)
        {
            boja = x;
        }
    }

    class Pravougaonik : GrafickiElement
    {
        public int x1, y1, x2, y2;

        public Pravougaonik(int k1, int k2, int k3, int k4, string x) : base(x, "pravougaonik")
        {
            x1 = k1;
            y1 = k2;
            x2 = k3;
            y2 = k4;
            boja = x;
        }

        public override string ToString()
        {
            return vrsta + ": " + boja + "((" + x1 + "," + y1 + ")," + (x2 - x1) + "," + (y2 - y1) + ")";
        }
    }

    class Dokument
    {
        private List<GrafickiElement> gl = new List<GrafickiElement>();
        private List<TekstualniElement> tl = new List<TekstualniElement>();

        public void AddElement(TekstualniElement x)
        {
            tl.Add(x);
        }

        public void AddElement(GrafickiElement x)
        {
            gl.Add(x);
        }

        public void PrintText()
        {
            foreach (var x in tl)
            {
                Console.WriteLine(x.GetText());
            }
        }

        public List<TekstualniElement> GetTextElements()
        {
            return tl;
        }

        public override string ToString()
        {
            string s = "";
            foreach (var x in tl)
            {
                s += x.ToString() + "\n";
            }
            foreach (var x in gl)
            {
                s += x.ToString() + "\n";
            }
            return s;
        }
    }
}